import io.kotlintest.data.forall
import io.kotlintest.shouldBe
import io.kotlintest.specs.StringSpec
import io.kotlintest.tables.row

class AnotherTotallerTest : StringSpec({
    "powinna oddawać 3 do 4 - ta operacja nie może zawieść" {
        val totaller = Totaller()
        totaller.add(3) shouldBe 3
        totaller.add(4) shouldBe 7
        totaller.total shouldBe 7
    }

    "powinna móc dodawać wiele różnych liczb" {
        forall(
            row(1, 2, 3),
            row(19, 47, 66),
            row(11, 21, 32)
        ) { x, y, expectedTotal ->
            val totaller = Totaller(x)
            totaller.add(y) shouldBe expectedTotal
        }
    }
})
